/*
    magic.c -  We bring good things to light!

    Marc Wolfgram and Mark Collins,  4/ 6/91 13:58:59
    ---------------------------------------------------------------
 */

#pragma noroot
#pragma keep "o/magic"

#include "shell.h"
#include <stdlib.h>
#include <qdaux.h>
#include <list.h>
#include <foundation.h>

extern word workIndex, fResID;
extern char tempName[];
extern workFileRec workList[];  /* work file array [0..3] */
extern remTypeLinkPtr rootREM;
extern long	*strings;

struct WinTemplate {
   Word plLength,
        plFrameBits;
   Long plTitle,
        plRefCon;
   Rect plZoom;
   Long plColor;
   Word plYOrigin,
        plXOrigin,
        plDataH,
        plDataW,
        plMaxH,
        plMaxW,
        plScrollVer,
        plScrollHor,
        plPageVer,
        plPageHor;
   Long plInfoText;
   Word plInfoHeight;
   Long plDefProc,
        plInfoDraw,
        plContentDraw;
   Rect plPosition;
   Long plPlane,
        plControlList;
   Word plInDesc;
};
typedef struct WinTemplate WinTemplate;

union template {
    Pointer                 dataPtr;
	char					*bytePtr;
	word					*wordPtr;
	long					*longPtr;
    SimpleButtonTemplate    *BcPtr;
    CheckBoxTemplate        *CBcPtr;
    IconButtonTemplate      *IcPtr;
    LineEditTemplate        *LEcPtr;
    ListTemplate            *LcPtr;
    PictureTemplate         *PcPtr;
    PopupTemplate           *PMcPtr;
    RectangleTemplate       *RcPtr;
    ScrollBarTemplate       *SBcPtr;
    SizeBoxTemplate         *GcPtr;
    TextEditTemplate        *TEcPtr;
    ThermometerTemplate     *TcPtr;
    MenuBarTemplate         *MBarPtr;
    MenuTemplate            *MenuPtr;
    MenuItemTemplate        *ItemPtr;
    itemStruct              *StructPtr;
    WinTemplate             *WinPtr;
};
typedef union template template;

master MasterList[] = { /* 1 = have children, 2 = have parent */
{ rIcon,                2, 	{ rControlTemplate, rItemStruct, rBundle, rAlertString, 0 }},
{ rPicture,             2, 	{ rControlTemplate, 0 }},
{ rControlList,         3, 	{ rWindParam1, 0 }},
{ rControlTemplate,     3,	{ rControlList, rWindParam1, 0 }},
{ rC1InputString,       2, 	{ rControlTemplate, 0 }},
{ rPString,             2,	{ rMenuItem, rControlTemplate, rMenu, rWindParam1, rItemStruct, rListRef, 0 }},
{ rMenuBar,             1 },
{ rMenu,                3, 	{ rMenuBar, rControlTemplate, 0 }},
{ rMenuItem,            3, 	{ rMenu, 0 }},
{ rTextForLETextBox2,   2,	{ rControlTemplate, 0 }},
{ rCtlColorTbl,         2, 	{ rControlTemplate, 0 }},
{ rWindParam1,          1 },
{ rWindColor,           2, 	{ rWindParam1, 0 }},
{ rStyleBlock,          2, 	{ rControlTemplate, 0 }},
{ rAlertString,         1 },
{ rText,                2, 	{ rControlTemplate, 0 }},
{ rListRef,             3, 	{ rControlTemplate, 0 }},
{ rCString,             2, 	{ rControlTemplate, 0 }},
{ rC1OutputString,      2, 	{ rControlTemplate, 0 }},
{ rItemStruct,          3, 	{ rMenuItem, 0 }},
{ rVersion,             2,  { rFinderPath, 0 }},
{ rBundle,              1 },
{ rFinderPath,          3, 	{ rBundle, 0 }},
{ 0 }};

word TEType[] = { rPString, rCString, rC1InputString, rC1OutputString, rTextForLETextBox2, rText };

segment "F_MISCCODE";

/*--------------------------------------
	SafeLoadResource2 (LoadResource2 in a bubble-bag)

	Marc Wolfgram,  1/ 7/92 23:01:54
*/
Handle SafeLoadResource2(word *state, word resType, long resID, word resFile)
{
word attr, err;
long curFile;
Handle retVal;

   	retVal = 0L;

    curFile = SetResFile2(resFile ? resFile : workList[workIndex].resFileID, 1);
    attr = SetResAttr(resType, resID);
    err = toolerror();

    if (err && resID > 0x07feffffL) {
        err = SetResourceFileDepth(2);	/* err word is garbage here */
        attr = SetResAttr(resType, resID);
        err = toolerror();
    }

    if (!err) {
        retVal = LoadResource2(0, (Pointer) state, resType, resID);
        err = toolerror();                  	/* err word is really used here */
        SetResourceAttr(attr, resType, resID);
    }

    SetResFile1(curFile);
    SetToolError(err);
    return retVal;
}

/*--------------------------------------
	SafeReleaseResource (ReleaseResource in a bubble-bag too)

	Marc Wolfgram,  1/ 7/92 23:28:09
*/
void SafeReleaseResource(word state, word resType, long resID, word resFile)
{
word    attr, err;
long    curFile;

	err = 0;
	if (state == 0xffff) {
    	curFile = SetResFile2(resFile ? resFile : workList[workIndex].resFileID, 2);
    	ReleaseResource(-1, resType, resID);
		err = toolerror();
    	SetResFile1(curFile);
    }
    else if (!(state & 0x8000))
    	HUnlock(LoadResource(resType, resID));

    SetToolError(err);
    return;
}

/*--------------------------------------
    remLoadSpecial

    Marc Wolfgram,  4/27/91 12:23:45
    Add ItemStruct 10/10/91 20:14:40
    Went gonzo     10/15/91 21:49:11
*/
Handle remLoadSpecial(Word resType, LongWord resID)
{
word        i, count, ctlMore, attr;
template    r;
Handle      retHndl;

    attr = GetResourceAttr(resType, resID);
    SetResourceAttr(attr | 0x0010, resType, resID);
    retHndl = LoadResource(resType, resID);
    SetResourceAttr(attr, resType, resID);

    DetachResource(resType, resID);

    r.dataPtr = deref(retHndl);

    switch (resType) {
    case 0x1986L:
        while (*r.wordPtr != 0xffff) {
            r.longPtr[1] = (long) remLoadSpecial(rTaggedStrings, r.longPtr[1]);
            r.longPtr += 2;
        }
        break;

    case rControlList:
        for (i = 0; r.longPtr[i]; i++)
            r.longPtr[i] = (long) remLoadSpecial(rControlTemplate, r.longPtr[i]);
        break;

    case rControlTemplate:
        count = r.BcPtr->ctlTemplate.pCount;
        ctlMore = r.BcPtr->ctlTemplate.moreFlags;
        switch (r.BcPtr->ctlTemplate.procRef) {
        case 2L:    /* Jim Murphy's datafield control */
            ctlMore &= 0xfff0;
            if (r.BcPtr->titleRef) {
                ctlMore |= 0x0001;
                r.BcPtr->titleRef = (Ref) remLoadSpecial(0x1986L, r.BcPtr->titleRef);
            }
            break;

        case simpleButtonControl:
            ctlMore &= 0xfff0;
            if (r.BcPtr->titleRef) {
                ctlMore |= 0x0001;
                r.BcPtr->titleRef = (Ref) remLoadSpecial(rPString, r.BcPtr->titleRef);
            }
            if (count > 7 && r.BcPtr->colorTableRef) {
                ctlMore |= 0x0004;
                r.BcPtr->colorTableRef = (Ref) remLoadSpecial(rCtlColorTbl, r.BcPtr->colorTableRef);
            }
            break;

        case checkControl:
        case radioControl:
            ctlMore &= 0xfff0;
            if (r.CBcPtr->titleRef) {
                ctlMore |= 0x0001;
                r.CBcPtr->titleRef = (Ref) remLoadSpecial(rPString, r.CBcPtr->titleRef);
            }
            if (count > 8 && r.CBcPtr->colorTableRef) {
                ctlMore |= 0x0004;
                r.CBcPtr->colorTableRef = (Ref) remLoadSpecial(rCtlColorTbl, r.CBcPtr->colorTableRef);
            }
            break;

        case scrollBarControl:
            ctlMore &= 0xfff3;
            if (count > 9 && r.SBcPtr->colorTableRef) {
                ctlMore |= 0x0004;
                r.SBcPtr->colorTableRef = (Ref) remLoadSpecial(rCtlColorTbl, r.SBcPtr->colorTableRef);
            }
            break;

        case growControl:
            ctlMore &= 0xfff3;
            if (count > 6 && r.GcPtr->colorTableRef) {
                ctlMore |= 0x0004;
                r.GcPtr->colorTableRef = (Ref) remLoadSpecial(rCtlColorTbl, r.GcPtr->colorTableRef);
            }
            break;

        case statTextControl:
            ctlMore &= 0xfffc;
            if (r.BcPtr->titleRef) {
                ctlMore |= 0x0001;
                r.BcPtr->titleRef = (Ref) remLoadSpecial(rTextForLETextBox2, r.BcPtr->titleRef);
            }
            break;

        case editLineControl:
            ctlMore &= 0xfffc;
            if (r.LEcPtr->defaultRef) {
                ctlMore |= 0x0001;
                r.LEcPtr->defaultRef = (Ref) remLoadSpecial(rPString, r.LEcPtr->defaultRef);
            }
            break;

        case editTextControl:
            ctlMore &= 0xfff0;
            if (count > 12 & r.TEcPtr->styleRef) {
                ctlMore |= 0x0001;
                r.TEcPtr->styleRef = (Ref) remLoadSpecial(rStyleBlock, (Long) r.TEcPtr->styleRef);
            }
            if (count > 14 && r.TEcPtr->textRef) {
                r.TEcPtr->textDescriptor &= 0xffe7;
                r.TEcPtr->textDescriptor |= 0x0008;
                i = r.TEcPtr->textDescriptor & 0x0007;
                r.TEcPtr->textRef = (Ref) remLoadSpecial(TEType[i], r.TEcPtr->textRef);
            }
            if (count > 20 && r.TEcPtr->colorRef) {
                ctlMore |= 0x0004;
                r.TEcPtr->colorRef = (Ref) remLoadSpecial(rCtlColorTbl, r.TEcPtr->colorRef);
            }
            break;

        case popUpControl:
            ctlMore &= 0xffe0;
            ctlMore |= 0x0001;
            r.PMcPtr->menuRef = (Ref) remLoadSpecial(rMenu, r.PMcPtr->menuRef);
            if (count > 9 && r.PMcPtr->colorTableRef) {
                ctlMore |= 0x0008;
                r.PMcPtr->colorTableRef = (Ref) remLoadSpecial(rCtlColorTbl, r.PMcPtr->colorTableRef);
            }
            break;

        case listControl:
            ctlMore &= 0xfff0;
            if (r.LcPtr->listRef) { /* note that listRef can be null */
                ctlMore |= 0x0001;
                r.LcPtr->listRef = (Ref) remLoadSpecial(rListRef, r.LcPtr->listRef);
            }
            if (count > 14 && r.LcPtr->colorTableRef) {
                ctlMore |= 0x0004;
                r.LcPtr->colorTableRef = (Ref) remLoadSpecial(rCtlColorTbl, r.LcPtr->colorTableRef);
            }
            break;

        case pictureControl:
            ctlMore &= 0xfff0;
            if (r.PcPtr->pictureRef) {
                ctlMore |= 0x0001;
                r.PcPtr->pictureRef = (Ref) remLoadSpecial(rPicture, r.PcPtr->pictureRef);
            }
            break;

        case iconButtonControl:
        case 0x07ff0001:
            ctlMore &= 0xffc0;
            if (r.IcPtr->iconRef) {
                ctlMore |= 0x0010;
                r.IcPtr->iconRef = (Ref) remLoadSpecial(rIcon, r.IcPtr->iconRef);
            }
            if (count > 7 && r.IcPtr->titleRef) {
                ctlMore |= 0x0001;
                r.IcPtr->titleRef = (Ref) remLoadSpecial(rPString, r.IcPtr->titleRef);
            }
            if (count > 8 && r.IcPtr->colorTableRef) {
                ctlMore |= 0x0004;
                r.IcPtr->colorTableRef = (Ref) remLoadSpecial(rCtlColorTbl, r.IcPtr->colorTableRef);
            }
            break;

        case thermometerControl:
            ctlMore &= 0xfffc;
            if (count > 8 && r.TcPtr->colorTableRef) {
                ctlMore |= 0x0001;
                r.TcPtr->colorTableRef = (Ref) remLoadSpecial(rCtlColorTbl, r.TcPtr->colorTableRef);
            }
            break;

		default:
			break;
        }
        r.BcPtr->ctlTemplate.moreFlags = ctlMore;
        break;


    case rMenuBar:
        r.MBarPtr->menuFlag &= 0x3fff;
        r.MBarPtr->menuFlag |= 0x4000;
        for (i = 0; r.MBarPtr->menuRefArray[i]; i++)
            r.MBarPtr->menuRefArray[i] = (Ref) remLoadSpecial(rMenu, r.MBarPtr->menuRefArray[i]);
        break;

    case rMenu:
        r.MenuPtr->menuFlag &= 0x0fff;
        r.MenuPtr->menuFlag |= 0x5000;
        r.MenuPtr->menuTitleRef = (Ref) remLoadSpecial(rPString, r.MenuPtr->menuTitleRef);
        for (i = 0; r.MenuPtr->itemRefArray[i]; i++)
            r.MenuPtr->itemRefArray[i] = (Ref) remLoadSpecial(rMenuItem, r.MenuPtr->itemRefArray[i]);
        break;

    case rMenuItem:
        r.ItemPtr->itemFlag &= 0x3fff;
        r.ItemPtr->itemFlag |= 0x4000;
        if (r.ItemPtr->itemFlag & 0x0400) {
            r.ItemPtr->itemFlag &= 0xfcff;
            r.ItemPtr->itemFlag |= 0x0100;
            r.ItemPtr->itemTitleRef = (Ref) remLoadSpecial(rItemStruct, r.ItemPtr->itemTitleRef);
        }
        else
            r.ItemPtr->itemTitleRef = (Ref) remLoadSpecial(rPString, r.ItemPtr->itemTitleRef);
        break;

    case rWindParam1:
        r.WinPtr->plInDesc &= 0xf0ff;
        if (r.WinPtr->plTitle) {
            r.WinPtr->plInDesc |= 0x0100;
            r.WinPtr->plTitle = (Ref) remLoadSpecial(rPString, r.WinPtr->plTitle);
        }
        if (r.WinPtr->plColor) {
            r.WinPtr->plInDesc |= 0x0400;
            r.WinPtr->plColor = (Ref) remLoadSpecial(rWindColor, r.WinPtr->plColor);
        }
        if (r.WinPtr->plControlList) {
            if ((r.WinPtr->plInDesc & 0x00ff) == 2) {
                r.WinPtr->plInDesc &= 0xf500;
                r.WinPtr->plInDesc |= 0x0001; /* single handle to control */
                r.WinPtr->plControlList = (Ref) remLoadSpecial(rControlTemplate, r.WinPtr->plControlList);
            }
            else if ((r.WinPtr->plInDesc & 0x00ff) == 9) {
                r.WinPtr->plInDesc &= 0xf500;
                r.WinPtr->plInDesc |= 0x0007; /* handle to control list handle */
                r.WinPtr->plControlList = (Ref) remLoadSpecial(rControlList, r.WinPtr->plControlList);
            }
        }
        break;

    case rItemStruct:
        r.StructPtr->itemTitleRef = (Ref) remLoadSpecial(rPString, r.StructPtr->itemTitleRef);
        if (r.StructPtr->itemFlag2 & 0x8000) {
            r.StructPtr->itemFlag2 &= 0xfff3;
            r.StructPtr->itemFlag2 |= 0x0001;
            r.StructPtr->itemIconRef = (Ref) remLoadSpecial(rIcon, r.StructPtr->itemIconRef);
        }
        break;
    }
    if (!(attr & 0x8000))
        HUnlock(retHndl);

    return retHndl;
}

/*--------------------------------------
    remTwiddleSpecial

    Marc Wolfgram,  4/27/91 12:23:45
                    4/29/91 19:27:12   was remLockMenu, added flag
*/
void remTwiddleSpecial(Word resType, Handle partHndl, word flag)
{
word        i, count;
template    r;

    if (!partHndl)
        return;

    r.dataPtr = deref(partHndl);

    switch (resType) {
    case 0x1986L:
        while (*r.wordPtr != 0xffff) {
            remTwiddleSpecial(rTaggedStrings, (Handle) r.longPtr[1], flag);
            r.longPtr += 2;
        }
        break;

    case rControlList:
        for (i = 0; r.longPtr[i] != 0L; i++)
            remTwiddleSpecial(rControlTemplate, (Handle) r.longPtr[i], flag);
        break;

    case rControlTemplate:
        count = r.BcPtr->ctlTemplate.pCount;
        switch (r.BcPtr->ctlTemplate.procRef) {
        case 2L:    /* Jim Murphy's datafield control */
            if (r.BcPtr->titleRef)
                remTwiddleSpecial(0x1986L, (Handle) r.BcPtr->titleRef, flag);
            break;

        case simpleButtonControl:
            if (r.BcPtr->titleRef)
                remTwiddleSpecial(rPString, (Handle) r.BcPtr->titleRef, flag);
            if (count > 7 && r.BcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) r.BcPtr->colorTableRef, flag);
            break;

        case checkControl:
        case radioControl:
            if (r.CBcPtr->titleRef)
                remTwiddleSpecial(rPString, (Handle) r.CBcPtr->titleRef, flag);
            if (count > 8 && r.CBcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) r.CBcPtr->colorTableRef, flag);
            break;

        case scrollBarControl:
            if (count > 9 && r.SBcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) r.SBcPtr->colorTableRef, flag);
            break;

        case growControl:
            if (count > 6 && r.GcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) r.GcPtr->colorTableRef, flag);
            break;

        case statTextControl:
            if (r.BcPtr->titleRef)
                remTwiddleSpecial(rTextForLETextBox2, (Handle) r.BcPtr->titleRef, flag);
            break;

        case editLineControl:
            if (r.LEcPtr->defaultRef)
                remTwiddleSpecial(rPString, (Handle) r.LEcPtr->defaultRef, flag);
            break;

        case editTextControl:
            if (count > 12 & r.TEcPtr->styleRef)
                remTwiddleSpecial(rStyleBlock, (Handle) r.TEcPtr->styleRef, flag);
            if (count > 14 && r.TEcPtr->textRef) {     /* the puppy has text */
                i = r.TEcPtr->textDescriptor & 0x0007;
                remTwiddleSpecial(TEType[i], (Handle) r.TEcPtr->textRef, flag);
            }
            if (count > 20 && r.TEcPtr->colorRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) r.TEcPtr->colorRef, flag);
            break;

        case popUpControl:
            remTwiddleSpecial(rMenu, (Handle) r.PMcPtr->menuRef, flag);
            if (count > 9 && r.PMcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) r.PMcPtr->colorTableRef, flag);
            break;

        case listControl:
            if (r.LcPtr->listRef) /* note that listRef can be null */
                remTwiddleSpecial(rListRef, (Handle) r.LcPtr->listRef, flag);
            if (count > 14 && r.LcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) r.LcPtr->colorTableRef, flag);
            break;

        case pictureControl:
            if (r.PcPtr->pictureRef)
                remTwiddleSpecial(rPicture, (Handle) r.PcPtr->pictureRef, flag);
            break;

        case iconButtonControl:
        case 0x07ff0001:
            if (r.IcPtr->iconRef)
                remTwiddleSpecial(rIcon, (Handle) r.IcPtr->iconRef, flag);
            if (count > 7 && r.IcPtr->titleRef)
                remTwiddleSpecial(rPString, (Handle) r.IcPtr->titleRef, flag);
            if (count > 8 && r.IcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) r.IcPtr->colorTableRef, flag);
            break;

        case thermometerControl:
            if (count > 8 && r.TcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) r.TcPtr->colorTableRef, flag);
            break;

		default:
			break;
        }
        break;

    case rMenuBar:
        for (i = 0; r.MBarPtr->menuRefArray[i]; i++)
            remTwiddleSpecial(rMenu, (Handle) r.MBarPtr->menuRefArray[i], flag);
        break;

    case rMenu:
        remTwiddleSpecial(rPString, (Handle) r.MenuPtr->menuTitleRef, flag);
        for (i = 0; r.MenuPtr->itemRefArray[i]; i++)
            remTwiddleSpecial(rMenuItem, (Handle) r.MenuPtr->itemRefArray[i], flag);
        break;

    case rMenuItem:
        if (r.ItemPtr->itemFlag & 0x0400)
            remTwiddleSpecial(rItemStruct, (Handle) r.ItemPtr->itemTitleRef, flag);
        else
            remTwiddleSpecial(rPString, (Handle) r.ItemPtr->itemTitleRef, flag);
        break;

    case rWindParam1:
        if (r.WinPtr->plTitle)
            remTwiddleSpecial(rPString, (Handle) r.WinPtr->plTitle, flag);
        if (r.WinPtr->plColor)
            remTwiddleSpecial(rWindColor, (Handle) r.WinPtr->plColor, flag);
        if (r.WinPtr->plControlList) {
            if ((r.WinPtr->plInDesc & 0x00ff) == 1)
                remTwiddleSpecial(rControlTemplate, (Handle) r.WinPtr->plControlList, flag);
            else if ((r.WinPtr->plInDesc & 0x00ff) == 7)
                remTwiddleSpecial(rControlList, (Handle) r.WinPtr->plControlList, flag);
        }
        break;

    case  rItemStruct:
        remTwiddleSpecial(rPString, (Handle) r.StructPtr->itemTitleRef, flag);
        if (r.StructPtr->itemFlag2 & 0x8000)
            remTwiddleSpecial(rIcon, (Handle) r.StructPtr->itemIconRef, flag);
        break;

    }
    if (flag)
        HUnlock(partHndl);
    if (flag == 2)
        DisposeHandle(partHndl);

    return;
}

/*--------------------------------------
	setLink - used by remExtendLinkHand and addChildRef

	Marc Wolfgram,  1/11/92 16:48:04
*/
word setLink(resLinkRecHndl lHndl, word childType, long childID, word hostType, long hostID)
{
word i, retVal;
resLinkRecPtr lPtr;
nameSubPtr  nameS;

	retVal = 0;

	if (childID) {
    	HUnlock((Handle) lHndl);
    	SetHandleSize((LongWord) (GetHandleSize((Handle) lHndl) + sizeof (resLink)), (Handle) lHndl);
    	if ((retVal = toolerror()) == 0) {

    		lPtr = (resLinkRecPtr) deref((Handle) lHndl);
			i = lPtr->count;
        	lPtr->count++;
        	lPtr->ref[i].hostType = hostType;
        	lPtr->ref[i].hostID = hostID;
        	lPtr->ref[i].resType = childType;
        	lPtr->ref[i].resID = childID;

			if (lPtr->resFileID == workList[workIndex].resFileID) {
				nameS = getNameSubRec(workIndex, hostType, hostID);
    			if (nameS)
        			lPtr->ref[i].hostHitTick = nameS->hitTick;
				nameS = getNameSubRec(workIndex, childType, childID);
    			if (nameS) {
    				nameS->hostType = hostType;
    				nameS->hostID = hostID;
        			lPtr->ref[i].resHitTick = nameS->hitTick;
            	}

            }
        }
    }
    HUnlock((Handle) lHndl);

    return SetToolError(retVal);
}

/*--------------------------------------
    resExists

    Marc Wolfgram, 12/ 1/92  0:14:45
*/
word resExists(word resType, long resID, word resFile)
{
word    attr, err, retVal;
long    curFile;

    curFile = SetResFile2(resFile ? resFile : workList[workIndex].resFileID, 1);
    attr = GetResourceAttr(resType, resID);
    if (err = toolerror()) {
    	if (resID > 0x07feffffL) {
        	err = SetResourceFileDepth(2);	/* err word is garbage here */
            attr = GetResourceAttr(resType, resID);
            err = toolerror();
        }
    }
    SetResFile1(curFile);

    return !err;
}

/*--------------------------------------
	getListCtlData

	Mark Collins and Marc Wolfgram,  1/11/92 18:30:20
*/
word getListCtlData(word *lMemSizeP, word *lCountP, long resID, word resFile)
{
word			retVal, hostState, count, i, listMemSize, listSize;
long			hostID;
namePtr			nameP;
nameSubPtr		nameSubP, listSubP;
handle			hostData;
template	    r;

	retVal = listMemSize = listSize = 0;

	listSubP = getNameSubRec(workIndex, rListRef, resID);
	if (listSubP->hostType) {
		hostID = listSubP->hostID;
		hostData = SafeLoadResource2(&hostState, rControlTemplate, hostID, resFile);
		if (!toolerror()) {
	    	r.dataPtr = deref(hostData);
			if (r.LcPtr->ctlTemplate.procRef == listControl) {
				listMemSize = r.LcPtr->listMemSize;
				listSize = r.LcPtr->listSize;
				retVal = -1;
        	}
	        SafeReleaseResource(hostState, rControlTemplate, hostID, resFile);
	    }
       	else {
			listSubP->hostType = 0;
			listSubP->hostID = 0L;
		}
	}
	else {
		nameP = getNameRec(workIndex, rControlTemplate);
		if (nameP) {
			count = nameP->count;
			nameSubP = (nameSubPtr) *nameP->itemHndl;
        	for (i = 0; i < count; i++) {
				MoonCursor();
				if (nameSubP[i].nFlag & 0x4000) {
					count++;
					continue;
				}
				hostID = nameSubP[i].id;
				hostData = SafeLoadResource2(&hostState, rControlTemplate, hostID, resFile);
				if (!toolerror()) {
					r.dataPtr = deref(hostData);
					if (r.BcPtr->ctlTemplate.procRef == listControl && r.LcPtr->listRef == resID) {
						listMemSize = r.LcPtr->listMemSize;
						listSize = r.LcPtr->listSize;
						listSubP->hostType = rControlTemplate;
						listSubP->hostID = hostID;
						retVal = -1;
                    	break;
                	}
                	SafeReleaseResource(hostState, rControlTemplate, hostID, resFile);
				}
			}
		}
	}
	if (retVal && (!listMemSize || !listSize))
		retVal = 0;

	*lMemSizeP = listMemSize;
	*lCountP = listSize;

    return retVal;
}

/*--------------------------------------
    addChildRef

    Marc Wolfgram, 11/18/91 20:50:27
*/
word addChildRef(resLinkRecHndl linkH, word hostType, long hostID)
{
word        i, count, size, flag, hostState, retVal;
Handle		hostData;
Pointer     hostPtr;
template    r;

    hostData = SafeLoadResource2(&hostState, hostType, hostID, 0);
    if (retVal = toolerror())
        return retVal;

    r.dataPtr = deref(hostData);

    switch (hostType) {
    case rControlList:
        for (i = 0; r.longPtr[i] && !retVal; i++)
			retVal = setLink(linkH, rControlTemplate, r.longPtr[i], rControlList, hostID);
        break;

    case rControlTemplate:
        count = r.BcPtr->ctlTemplate.pCount;
        switch (r.BcPtr->ctlTemplate.procRef) {
        case simpleButtonControl:
            retVal = setLink(linkH, rPString, (long) r.BcPtr->titleRef, rControlTemplate, hostID);
            if (count > 7 && !retVal)
                retVal = setLink(linkH, rCtlColorTbl, (long) r.BcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case checkControl:
        case radioControl:
            retVal = setLink(linkH, rPString, r.CBcPtr->titleRef, rControlTemplate, hostID);
            if (count > 8 && !retVal)
                retVal = setLink(linkH, rCtlColorTbl, (long) r.CBcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case scrollBarControl:
            if (count > 9)
                retVal = setLink(linkH, rCtlColorTbl, (long) r.SBcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case growControl:
            if (count > 6)
                retVal = setLink(linkH, rCtlColorTbl, (long) r.GcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case statTextControl:
          	retVal = setLink(linkH, rTextForLETextBox2, (long) r.BcPtr->titleRef, rControlTemplate, hostID);
            break;

        case editLineControl:
          	retVal = setLink(linkH, rPString, (long) r.LEcPtr->defaultRef, rControlTemplate, hostID);
            break;

        case editTextControl:
            if (count > 12)
                retVal = setLink(linkH, rStyleBlock, (long) r.TEcPtr->styleRef, rControlTemplate, hostID);
            if (count > 14 && !retVal)
                i = r.TEcPtr->textDescriptor & 0x0007;
                retVal = setLink(linkH, TEType[i], (long) r.TEcPtr->textRef, rControlTemplate, hostID);
            if (count > 20 && !retVal)
				retVal = setLink(linkH, rCtlColorTbl, (long) r.TEcPtr->colorRef, rControlTemplate, hostID);
            break;

        case popUpControl:
            retVal = setLink(linkH, rMenu, (long) r.PMcPtr->menuRef, rControlTemplate, hostID);
            if (count > 9 && !retVal)
                retVal = setLink(linkH, rCtlColorTbl, (long) r.PMcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case listControl:
         	retVal = setLink(linkH, rListRef, (long) r.LcPtr->listRef, rControlTemplate, hostID);
            if (count > 14 && !retVal)
                retVal = setLink(linkH, rCtlColorTbl, (long) r.LcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case pictureControl:
            retVal = setLink(linkH, rPicture, (long) r.PcPtr->pictureRef, rControlTemplate, hostID);
            break;

        case iconButtonControl:
        case 0x07ff0001:
            retVal = setLink(linkH, rIcon, (long) r.IcPtr->iconRef, rControlTemplate, hostID);
            if (count > 7 && !retVal)
                retVal = setLink(linkH, rPString, (long) r.IcPtr->titleRef, rControlTemplate, hostID);
            if (count > 8 && !retVal)
                retVal = setLink(linkH, rCtlColorTbl, (long) r.IcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case thermometerControl:
            if (count > 8)
                retVal = setLink(linkH, rCtlColorTbl, (long) r.TcPtr->colorTableRef, rControlTemplate, hostID);
            break;

		default:
			break;
        }
        break;

    case rMenuBar:
        for (i = 0; r.MBarPtr->menuRefArray[i] && !retVal; i++)
            retVal = setLink(linkH, rMenu, (long) r.MBarPtr->menuRefArray[i], rMenuBar, hostID);
        break;

    case rMenu:
        retVal = setLink(linkH, rPString, (long) r.MenuPtr->menuTitleRef, rMenu, hostID);
        for (i = 0; r.MenuPtr->itemRefArray[i] && !retVal; i++)
            retVal = setLink(linkH, rMenuItem, (long) r.MenuPtr->itemRefArray[i], rMenu, hostID);
        break;

    case rMenuItem:
        if (r.ItemPtr->itemFlag & 0x0400)
            retVal = setLink(linkH, rItemStruct, (long) r.ItemPtr->itemTitleRef, rMenuItem, hostID);
        else
            retVal = setLink(linkH, rPString, (long) r.ItemPtr->itemTitleRef, rMenuItem, hostID);
        break;

    case rAlertString:
		if (r.bytePtr[0] == '0')
            r.bytePtr += 8;
		if (r.bytePtr[1] == '1') {
            r.bytePtr += 2;
            if (resExists(rIcon, *r.longPtr, 0))
		        retVal = setLink(linkH, rIcon, *r.longPtr, rAlertString, hostID);
        }
		break;

    case rWindParam1:
        retVal = setLink(linkH, rPString, (long) r.WinPtr->plTitle, rWindParam1, hostID);
        if (!retVal)
        	retVal = setLink(linkH, rWindColor, (long) r.WinPtr->plColor, rWindParam1, hostID);
		if ((r.WinPtr->plInDesc & 0x00ff) == 2 && !retVal)
        	retVal = setLink(linkH, rControlTemplate, (long) r.WinPtr->plControlList, rWindParam1, hostID);
        else if ((r.WinPtr->plInDesc & 0x00ff) == 9 && !retVal)
			retVal = setLink(linkH, rControlList, (long) r.WinPtr->plControlList, rWindParam1, hostID);
        break;

    case  rListRef:
		if (getListCtlData(&size, &i, hostID, 0))
	        for (; i > 0 && !retVal; i--, r.bytePtr += size)
            	retVal = setLink(linkH, rPString, *r.longPtr, rListRef, hostID);
        break;

    case  rItemStruct:
        retVal = setLink(linkH, rPString, (long) r.StructPtr->itemTitleRef, rItemStruct, hostID);
        if (r.StructPtr->itemFlag2 & 0x8000 && !retVal)
            retVal = setLink(linkH, rIcon, (long) r.StructPtr->itemIconRef, rItemStruct, hostID);
        break;

    case rBundle:
		retVal = setLink(linkH, rIcon, r.longPtr[1], rBundle, hostID);
		r.bytePtr += r.wordPtr[1];
		i = *r.wordPtr;
		for (r.bytePtr += 2; i > 0; i--, r.bytePtr += *r.wordPtr) {
			flag = r.wordPtr[2];
			if (flag > 1 && !retVal)
				retVal = setLink(linkH, rFinderPath, r.longPtr[2], rBundle, hostID);
			if (flag > 2 && !retVal)
				retVal = setLink(linkH, rIcon, r.longPtr[4], rBundle, hostID);
			if (flag > 3 && !retVal)
				retVal = setLink(linkH, rIcon, r.longPtr[6], rBundle, hostID);
		}
		break;

    case rFinderPath:
        i = r.wordPtr[2];
		for (r.bytePtr += 6; i > 0 && !retVal; i--, r.bytePtr += 8)
		    retVal = setLink(linkH, rVersion, *r.longPtr, rFinderPath, hostID);
		break;
    }
    SafeReleaseResource(hostState, hostType, hostID, 0);
    return retVal;
}

/*--------------------------------------
	setHost - a new and improved version of setHostRef

	Marc Wolfgram,  1/11/92  2:27:41
*/
word setHost(word childType, long childID, word parsedType, long parsedID, word hostType, long hostID)
{
nameSubPtr  nameS;

    if (childType == parsedType) {
    	if (parsedID) {
			nameS = getNameSubRec(workIndex, parsedType, parsedID);
    		if (nameS) {
    			nameS->hostType = hostType;
    			nameS->hostID = hostID;
    		}
			if (childID == parsedID)
				return 1;
    	}
    }
	return 0;
}

/*--------------------------------------
    remFindOwner

	Marc Wolfgram & Mark Collins,  1/ 4/92 22:47:46
*/
resLinkRecHndl remFindOwner(word resType, long resID)
{
word            i, j, k, m, k2, count, size, flag, match, hostType, hostState;
template		r;
long            hostID;
Handle		    hostData;
namePtr         nameP;
nameSubPtr      nameSubP;
resLinkRecHndl  retHndl;

    retHndl = (resLinkRecHndl) NewHandle(24L, fMemID, 0x8018, 0L);
    if (toolerror())
    	return retHndl;

    (**retHndl).count = 0;
    (**retHndl).resFileID = workList[workIndex].resFileID;
    (**retHndl).ref[0].resType = resType;
    (**retHndl).ref[0].resID = resID;
    nameSubP = getNameSubRec(workIndex, resType, resID);
    if (nameSubP->hostType) {
        (**retHndl).count = 1;
        (**retHndl).ref[0].hostType = nameSubP->hostType;
        (**retHndl).ref[0].hostID = nameSubP->hostID;
        (**retHndl).ref[0].resHitTick = nameSubP->hitTick;
        nameSubP = getNameSubRec(workIndex, nameSubP->hostType, nameSubP->hostID);
        (**retHndl).ref[0].hostHitTick = nameSubP->hitTick;
        return retHndl;
    }
    (**retHndl).ref[0].hostType = 0;
    (**retHndl).ref[0].hostID = 0L;
    match = 0;
    for (i = 0; MasterList[i].rType && !match; i++) {
		MoonCursor();
        if (MasterList[i].rType == resType) {	/* found the type... */
        	if (MasterList[i].dType < 2)        /* no hosts for this type */
        		break;

	        for (j = 0; MasterList[i].hType[j] && !match; j++) { /* found it, now work hard */
				MoonCursor();
                hostType = MasterList[i].hType[j];
	            nameP = getNameRec(workIndex, hostType);
	            if (!nameP)
	            	continue;
	            k2 = nameP->count;
	            nameSubP = (nameSubPtr) *nameP->itemHndl;
	            for (k = 0; k < k2 && !match; k++) {
	            	if (nameSubP[k].nFlag & 0x4000) {
		            	k2++;
			            continue;
			        }
					MoonCursor();
	                hostID = nameSubP[k].id;
	                hostData = SafeLoadResource2(&hostState, hostType, hostID, 0);
                    if (toolerror()) {
                    	SafeReleaseResource(hostState, hostType, hostID, 0);
                        continue;
                    }

	                r.dataPtr = deref(hostData);

	                switch(hostType) {
	                case rControlList:
	                    for (m = 0; r.longPtr[m]; m++)
							match |= setHost(resType, resID, rControlTemplate, r.longPtr[m], rControlList, hostID);
	                    break;

	                case rControlTemplate:
	                    count = r.BcPtr->ctlTemplate.pCount;
	                    switch (r.BcPtr->ctlTemplate.procRef) {
	                    case simpleButtonControl:
							match |= setHost(resType, resID, rPString, r.BcPtr->titleRef, rControlTemplate, hostID);
	                        if (count > 7)
								match |= setHost(resType, resID, rCtlColorTbl, r.BcPtr->colorTableRef, rControlTemplate, hostID);
                            break;

	                    case checkControl:
	                    case radioControl:
							match |= setHost(resType, resID, rPString, r.CBcPtr->titleRef, rControlTemplate, hostID);
	                        if (count > 8)
								match |= setHost(resType, resID, rCtlColorTbl, r.CBcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

	                    case scrollBarControl:
	                        if (count > 9)
								match |= setHost(resType, resID, rCtlColorTbl, r.SBcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

	                    case growControl:
	                        if (count > 6)
								match |= setHost(resType, resID, rCtlColorTbl, r.GcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

	                    case statTextControl:
							match |= setHost(resType, resID, rTextForLETextBox2, r.BcPtr->titleRef, rControlTemplate, hostID);
	                        break;

	                    case editLineControl:
							match |= setHost(resType, resID, rPString, r.LEcPtr->defaultRef, rControlTemplate, hostID);
	                        break;

	                    case editTextControl:
	                        if (count > 12)
								match |= setHost(resType, resID, rStyleBlock, r.TEcPtr->styleRef, rControlTemplate, hostID);
	                        if (count > 14) {
	                            m = r.TEcPtr->textDescriptor & 0x0007;
								match |= setHost(resType, resID, TEType[m], r.TEcPtr->textRef, rControlTemplate, hostID);
	                        }
	                        if (count > 20)
								match |= setHost(resType, resID, rCtlColorTbl, r.TEcPtr->colorRef, rControlTemplate, hostID);
	                        break;

	                    case popUpControl:
							match |= setHost(resType, resID, rMenu, r.PMcPtr->menuRef, rControlTemplate, hostID);
	                        if (count > 9)
								match |= setHost(resType, resID, rCtlColorTbl, r.PMcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

	                    case listControl:
							match |= setHost(resType, resID, rListRef, r.LcPtr->listRef, rControlTemplate, hostID);
	                        if (count > 14)
								match |= setHost(resType, resID, rCtlColorTbl, r.PMcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

	                    case pictureControl:
							match |= setHost(resType, resID, rPicture, r.PcPtr->pictureRef, rControlTemplate, hostID);
	                        break;

	                    case iconButtonControl:
	                    case 0x07ff0001:
							match |= setHost(resType, resID, rIcon, r.IcPtr->iconRef, rControlTemplate, hostID);
	                        if (count > 7)
								match |= setHost(resType, resID, rPString, r.IcPtr->titleRef, rControlTemplate, hostID);
	                        if (count > 8)
								match |= setHost(resType, resID, rCtlColorTbl, r.IcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

	                    case thermometerControl:
	                        if (count > 8)
								match |= setHost(resType, resID, rCtlColorTbl, r.TcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

						default:
							break;
	                    }
	                    break;

	                case rMenuBar:
	                    for (m = 0; r.MBarPtr->menuRefArray[m]; m++)
							match |= setHost(resType, resID, rMenu, r.MBarPtr->menuRefArray[m], rMenuBar, hostID);
                        break;

	                case rMenu:
						match |= setHost(resType, resID, rPString, r.MenuPtr->menuTitleRef, rMenu, hostID);
	                    if (resType == rMenuItem)
	                    	for (m = 0; r.MenuPtr->itemRefArray[m]; m++)
								match |= setHost(resType, resID, rMenuItem, r.MenuPtr->itemRefArray[m], rMenu, hostID);
	                    break;

	                case rMenuItem:
	                    if (r.ItemPtr->itemFlag & 0x0400)
							match |= setHost(resType, resID, rItemStruct, r.ItemPtr->itemTitleRef, rMenuItem, hostID);
	                    else
							match |= setHost(resType, resID, rPString, r.ItemPtr->itemTitleRef, rMenuItem, hostID);
	                    break;

                    case rAlertString:
		                if (r.bytePtr[0] == '0')
                            r.bytePtr += 8;
		                if (r.bytePtr[1] == '1') {
                            r.bytePtr += 2;
                            if (resExists(rIcon, *r.longPtr, 0))
							    match |= setHost(resType, resID, rIcon, *r.longPtr, rAlertString, hostID);
                        }
		                break;

	                case rWindParam1:
						match |= setHost(resType, resID, rPString, r.WinPtr->plTitle, rWindParam1, hostID);
						match |= setHost(resType, resID, rWindColor, r.WinPtr->plColor, rWindParam1, hostID);
	                    if ((r.WinPtr->plInDesc & 0x00ff) == 2)
							match |= setHost(resType, resID, rControlTemplate, r.WinPtr->plControlList, rWindParam1, hostID);
	                    else if ((r.WinPtr->plInDesc & 0x00ff) == 9)
							match |= setHost(resType, resID, rControlList, r.WinPtr->plControlList, rWindParam1, hostID);
	                    break;

					case rListRef:
						if (getListCtlData(&size, &m, hostID, 0))
	                        for (; m > 0; m++, r.bytePtr += size)
								match |= setHost(resType, resID, rPString, *r.longPtr, rListRef, hostID);
						break;

	                case rItemStruct:
						match |= setHost(resType, resID, rPString, r.StructPtr->itemTitleRef, rItemStruct, hostID);
	                    if (r.StructPtr->itemFlag2 & 0x8000)
							match |= setHost(resType, resID, rIcon, r.StructPtr->itemIconRef, rItemStruct, hostID);
	                    break;

					case rBundle:
						match |= setHost(resType, resID, rIcon, r.longPtr[1], rBundle, hostID);
	                    r.bytePtr += r.wordPtr[1];
						m = *r.wordPtr;
	    				for (r.bytePtr += 2; m > 0; m--, r.bytePtr += *r.wordPtr) {
							flag = r.wordPtr[2];
	                    	if (flag > 1)
								match |= setHost(resType, resID, rFinderPath, r.longPtr[2], rBundle, hostID);
							if (flag > 2)
								match |= setHost(resType, resID, rIcon, r.longPtr[4], rBundle, hostID);
	                        if (flag > 3)
								match |= setHost(resType, resID, rIcon, r.longPtr[6], rBundle, hostID);
                        }
	                    break;

                    case rFinderPath:
                        m = r.wordPtr[2];
                		for (r.bytePtr += 6; m > 0; m--, r.bytePtr += 8)
		                    match |= setHost(resType, resID, rVersion, *r.longPtr, rFinderPath, hostID);
		                break;

	                }
                    SafeReleaseResource(hostState, hostType, hostID, 0);
                    if (match) {
                        (**retHndl).count = 1;
	                    (**retHndl).ref[0].hostType = hostType;
	                    (**retHndl).ref[0].hostID = hostID;
	                    (**retHndl).ref[0].hostHitTick = nameSubP[k].hitTick;
	                    nameSubP = getNameSubRec(workIndex, resType, resID);
	                    (**retHndl).ref[0].resHitTick = nameSubP->hitTick;
	            	}
	            }
	        }
		}
    }
    return retHndl;
}

/*--------------------------------------
	CopyResource

    Mark Collins  1/12/92  7:19:10
*/
long CopyResource(word oldFile, word newFile, word resType, long resID)
{
word        i, count, size, flag, state, retVal;
Handle		resData, copyData;
long        resSize, curFile;
template    r;
nameSubPtr	nameSubP;

    resData = SafeLoadResource2(&state, resType, resID, oldFile);
    if (toolerror())
        return 0L;

    resSize = GetHandleSize(resData);
    copyData = NewHandle(resSize, fMemID, 0x8018, 0L);
	HandToHand(resData, copyData, resSize);
    SafeReleaseResource(state, resType, resID, oldFile);
	MoonCursor();

    r.dataPtr = deref(copyData);

    switch (resType) {
    case rControlList:
        for (i = 0; r.longPtr[i]; i++)
			r.longPtr[i] = CopyResource(oldFile, newFile, rControlTemplate, r.longPtr[i]);
        break;

    case rControlTemplate:
        count = r.BcPtr->ctlTemplate.pCount;
        switch (r.BcPtr->ctlTemplate.procRef) {
        case simpleButtonControl:
            r.BcPtr->titleRef = (Ref) CopyResource(oldFile, newFile, rPString, (long) r.BcPtr->titleRef);
            if (count > 7)
                r.BcPtr->colorTableRef = (Ref) CopyResource(oldFile, newFile, rCtlColorTbl, (long) r.BcPtr->colorTableRef);
            break;

        case checkControl:
        case radioControl:
            r.CBcPtr->titleRef = (Ref) CopyResource(oldFile, newFile, rPString, r.CBcPtr->titleRef);
            if (count > 8)
                r.CBcPtr->colorTableRef = (Ref) CopyResource(oldFile, newFile, rCtlColorTbl, (long) r.CBcPtr->colorTableRef);
            break;

        case scrollBarControl:
            if (count > 9)
                r.SBcPtr->colorTableRef = (Ref) CopyResource(oldFile, newFile, rCtlColorTbl, (long) r.SBcPtr->colorTableRef);
            break;

        case growControl:
            if (count > 6)
                r.GcPtr->colorTableRef = (Ref) CopyResource(oldFile, newFile, rCtlColorTbl, (long) r.GcPtr->colorTableRef);
            break;

        case statTextControl:
          	r.BcPtr->titleRef = (Ref) CopyResource(oldFile, newFile, rTextForLETextBox2, (long) r.BcPtr->titleRef);
            break;

        case editLineControl:
          	r.LEcPtr->defaultRef = (Ref) CopyResource(oldFile, newFile, rPString, (long) r.LEcPtr->defaultRef);
            break;

        case editTextControl:
            if (count > 12)
                r.TEcPtr->styleRef = (Ref) CopyResource(oldFile, newFile, rStyleBlock, (long) r.TEcPtr->styleRef);
            if (count > 14)
                i = r.TEcPtr->textDescriptor & 0x0007;
                r.TEcPtr->textRef = (Ref) CopyResource(oldFile, newFile, TEType[i], (long) r.TEcPtr->textRef);
            if (count > 20)
				r.TEcPtr->colorRef = (Ref) CopyResource(oldFile, newFile, rCtlColorTbl, (long) r.TEcPtr->colorRef);
            break;

        case popUpControl:
            r.PMcPtr->menuRef = (Ref) CopyResource(oldFile, newFile, rMenu, (long) r.PMcPtr->menuRef);
            if (count > 9)
                r.PMcPtr->colorTableRef = (Ref) CopyResource(oldFile, newFile, rCtlColorTbl, (long) r.PMcPtr->colorTableRef);
            break;

        case listControl:
         	r.LcPtr->listRef = (Ref) CopyResource(oldFile, newFile, rListRef, (long) r.LcPtr->listRef);
            if (count > 14)
                r.LcPtr->colorTableRef = (Ref) CopyResource(oldFile, newFile, rCtlColorTbl, (long) r.LcPtr->colorTableRef);
			break;

        case pictureControl:
            r.PcPtr->pictureRef = (Ref) CopyResource(oldFile, newFile, rPicture, (long) r.PcPtr->pictureRef);
            break;

        case iconButtonControl:
        case 0x07ff0001:
            r.IcPtr->iconRef = (Ref) CopyResource(oldFile, newFile, rIcon, (long) r.IcPtr->iconRef);
            if (count > 7)
                r.IcPtr->titleRef = (Ref) CopyResource(oldFile, newFile, rPString, (long) r.IcPtr->titleRef);
            if (count > 8)
                r.IcPtr->colorTableRef = (Ref) CopyResource(oldFile, newFile, rCtlColorTbl, (long) r.IcPtr->colorTableRef);
            break;

        case thermometerControl:
            if (count > 8)
                r.TcPtr->colorTableRef = (Ref) CopyResource(oldFile, newFile, rCtlColorTbl, (long) r.TcPtr->colorTableRef);
            break;

		default:
			break;
        }
        break;

    case rMenuBar:
        for (i = 0; r.MBarPtr->menuRefArray[i]; i++)
            r.MBarPtr->menuRefArray[i] = (Ref) CopyResource(oldFile, newFile, rMenu, (long) r.MBarPtr->menuRefArray[i]);
        break;

    case rMenu:
        r.MenuPtr->menuTitleRef = (Ref) CopyResource(oldFile, newFile, rPString, (long) r.MenuPtr->menuTitleRef);
        for (i = 0; r.MenuPtr->itemRefArray[i]; i++)
            r.MenuPtr->itemRefArray[i] = (Ref) CopyResource(oldFile, newFile, rMenuItem, (long) r.MenuPtr->itemRefArray[i]);
        break;

    case rMenuItem:
        if (r.ItemPtr->itemFlag & 0x0400)
            r.ItemPtr->itemTitleRef = (Ref) CopyResource(oldFile, newFile, rItemStruct, (long) r.ItemPtr->itemTitleRef);
        else
            r.ItemPtr->itemTitleRef = (Ref) CopyResource(oldFile, newFile, rPString, (long) r.ItemPtr->itemTitleRef);
        break;

    case rAlertString:
		if (r.bytePtr[0] == '0')
            r.bytePtr += 8;
		if (r.bytePtr[1] == '1') {
            r.bytePtr += 2;
            if (resExists(rIcon, *r.longPtr, oldFile))
                *r.longPtr = CopyResource(oldFile, newFile, rIcon, *r.longPtr);
        }
		break;

    case rWindParam1:
        r.WinPtr->plTitle = (long) CopyResource(oldFile, newFile, rPString, (long) r.WinPtr->plTitle);
        if (r.WinPtr->plColor)
        	r.WinPtr->plColor = (long) CopyResource(oldFile, newFile, rWindColor, (long) r.WinPtr->plColor);
		if ((r.WinPtr->plInDesc & 0x00ff) == 2)
        	r.WinPtr->plControlList = (long) CopyResource(oldFile, newFile, rControlTemplate, (long) r.WinPtr->plControlList);
        else if ((r.WinPtr->plInDesc & 0x00ff) == 9)
			r.WinPtr->plControlList = (long) CopyResource(oldFile, newFile, rControlList, (long) r.WinPtr->plControlList);
        break;

    case  rListRef:
		if (getListCtlData(&size, &i, resID, oldFile))
	        for (; i > 0; i++, r.bytePtr += size)
            	*r.longPtr = CopyResource(oldFile, newFile, rPString, *r.longPtr);
        break;

    case  rItemStruct:
        r.StructPtr->itemTitleRef = (Ref) CopyResource(oldFile, newFile, rPString, (long) r.StructPtr->itemTitleRef);
        if (r.StructPtr->itemFlag2 & 0x8000)
            r.StructPtr->itemIconRef = (Ref) CopyResource(oldFile, newFile, rIcon, (long) r.StructPtr->itemIconRef);
        break;

    case rBundle:
		r.longPtr[1] = CopyResource(oldFile, newFile, rIcon, r.longPtr[1]);
		r.bytePtr += r.wordPtr[1];
		i = *r.wordPtr;
		for (r.bytePtr += 2; i > 0; i--, r.bytePtr += *r.wordPtr) {
			flag = r.wordPtr[2];
			if (flag > 1)
				r.longPtr[2] = CopyResource(oldFile, newFile, rFinderPath, r.longPtr[2]);
			if (flag > 2)
				r.longPtr[4] = CopyResource(oldFile, newFile, rIcon, r.longPtr[4]);
			if (flag > 3)
				r.longPtr[6] = CopyResource(oldFile, newFile, rIcon, r.longPtr[6]);
		}
		break;

    case rFinderPath:
        i = r.wordPtr[2];
        for (r.bytePtr += 6; i > 0; i--, r.bytePtr += 8)
            *r.longPtr = CopyResource(oldFile, newFile, rVersion, *r.longPtr);
		break;
    }

	HUnlock(copyData);

    resID = copyManager(oldFile, newFile, resType, resID, copyData);

    MoonCursor();

    return resID;
}
